<?php
/**
 * VIEW: production/index.php
 * Página de Produção
 */

// CSS e JS específicos desta página
$page_css = 'production.css';
$page_js = 'production.js';

// Incluir HEAD
include APP_PATH . '/views/partials/head.php';
?>

<!-- Incluir HEADER -->
<?php include APP_PATH . '/views/partials/header.php'; ?>

<!-- Hero Carousel Section -->
<section class="hero-section">
    <div class="custom-carousel" id="heroCarousel">
        <?php if (!empty($carousel_images)): ?>
            <?php foreach ($carousel_images as $index => $image): ?>
                <div class="carousel-slide <?= $index === 0 ? 'active' : '' ?>" 
                     data-title="<?= htmlspecialchars($image['title']) ?>"
                     data-subtitle="<?= htmlspecialchars($image['subtitle']) ?>">
                    <img src="<?= asset(htmlspecialchars($image['image_url'])) ?>" 
                         alt="<?= htmlspecialchars($image['image_alt']) ?>">
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
    
    <div class="hero-overlay"></div>
    
    <div class="hero-content">
        <h1 class="hero-title" id="heroTitle">
            <?= !empty($carousel_images) ? htmlspecialchars($carousel_images[0]['title']) : 'Nossa Produção' ?>
        </h1>
        <p class="hero-subtitle" id="heroSubtitle">
            <?= !empty($carousel_images) ? htmlspecialchars($carousel_images[0]['subtitle']) : 'Técnicas modernas de agricultura sustentável' ?>
        </p>
    </div>
    
    <div class="carousel-nav">
        <button class="carousel-btn" onclick="prevSlide()">
            <i class="fas fa-chevron-left"></i>
        </button>
        <button class="carousel-btn" onclick="nextSlide()">
            <i class="fas fa-chevron-right"></i>
        </button>
    </div>
</section>

<!-- Products Section -->
<section class="products-section">
    <div class="container top-card">
        <div class="products-grid">
            <!-- Card 1 -->
            <div class="product-card">
                <div class="product-image">
                    <?php if (!empty($products_card1)): ?>
                        <?php foreach ($products_card1 as $index => $product): ?>
                            <img src="<?= asset(htmlspecialchars($product['image_url'])) ?>" 
                                 alt="<?= htmlspecialchars($product['product_name']) ?>"
                                 class="<?= $index === 0 ? 'active' : '' ?>"
                                 data-product="<?= htmlspecialchars($product['product_slug']) ?>">
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
                <div class="product-info">
                    <h3 class="product-title" id="productTitle1">
                        <?= !empty($products_card1) ? htmlspecialchars($products_card1[0]['product_name']) : '' ?>
                    </h3>
                    <div class="product-details-inline">
                        <?php if (!empty($products_card1)): ?>
                            <?php foreach ($products_card1 as $index => $product): ?>
                                <p class="detail-text <?= $index === 0 ? 'active' : '' ?>" 
                                   data-product="<?= htmlspecialchars($product['product_slug']) ?>">
                                    <?= nl2br(htmlspecialchars($product['description'])) ?>
                                </p>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Card 2 -->
            <div class="product-card">
                <div class="product-image">
                    <?php if (!empty($products_card2)): ?>
                        <?php foreach ($products_card2 as $index => $product): ?>
                            <img src="<?= asset(htmlspecialchars($product['image_url'])) ?>" 
                                 alt="<?= htmlspecialchars($product['product_name']) ?>"
                                 class="<?= $index === 0 ? 'active' : '' ?>"
                                 data-product="<?= htmlspecialchars($product['product_slug']) ?>">
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
                <div class="product-info">
                    <h3 class="product-title" id="productTitle2">
                        <?= !empty($products_card2) ? htmlspecialchars($products_card2[0]['product_name']) : '' ?>
                    </h3>
                    <div class="product-details-inline">
                        <?php if (!empty($products_card2)): ?>
                            <?php foreach ($products_card2 as $index => $product): ?>
                                <p class="detail-text <?= $index === 0 ? 'active' : '' ?>" 
                                   data-product="<?= htmlspecialchars($product['product_slug']) ?>">
                                    <?= nl2br(htmlspecialchars($product['description'])) ?>
                                </p>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Card 3 -->
            <div class="product-card">
                <div class="product-image">
                    <?php if (!empty($products_card3)): ?>
                        <?php foreach ($products_card3 as $index => $product): ?>
                            <img src="<?= asset(htmlspecialchars($product['image_url'])) ?>" 
                                 alt="<?= htmlspecialchars($product['product_name']) ?>"
                                 class="<?= $index === 0 ? 'active' : '' ?>"
                                 data-product="<?= htmlspecialchars($product['product_slug']) ?>">
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
                <div class="product-info">
                    <h3 class="product-title" id="productTitle3">
                        <?= !empty($products_card3) ? htmlspecialchars($products_card3[0]['product_name']) : '' ?>
                    </h3>
                    <div class="product-details-inline">
                        <?php if (!empty($products_card3)): ?>
                            <?php foreach ($products_card3 as $index => $product): ?>
                                <p class="detail-text <?= $index === 0 ? 'active' : '' ?>" 
                                   data-product="<?= htmlspecialchars($product['product_slug']) ?>">
                                    <?= nl2br(htmlspecialchars($product['description'])) ?>
                                </p>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Production Title Section -->
<section class="production-title">
    <div class="container">
        <h2>
            <?= isset($page['statistics_title']) ? htmlspecialchars($page['statistics_title']) : '' ?>
        </h2>
        <p>
            <?= isset($page['statistics_subtitle']) ? htmlspecialchars($page['statistics_subtitle']) : '' ?>
        </p>
    </div>
</section>
<!-- Statistics Section -->
<section class="statistics-section">
    <div class="container">
        <div class="statistics-grid">
            <?php 
            // Mostrar sempre 3 cards fixos
            // O JavaScript vai rotacionar o conteúdo desses 3 cards
            for ($i = 0; $i < 3; $i++): 
                $stat = isset($statistics[$i]) ? $statistics[$i] : null;
            ?>
                <div class="stat-card">
                    <div class="stat-image">
                        <img src="<?= $stat ? asset(htmlspecialchars($stat['image_url'])) : asset('images/placeholder.jpg') ?>" 
                             alt="<?= $stat ? htmlspecialchars($stat['product_name']) : 'Estatística' ?>" 
                             class="active" 
                             id="statImg<?= $i + 1 ?>">
                    </div>
                    <div class="stat-value" 
                         id="statValue<?= $i + 1 ?>"
                         data-target="<?= $stat ? htmlspecialchars($stat['value']) : '0' ?>">0</div>
                    <div class="stat-label" id="statLabel<?= $i + 1 ?>">
                        <?= $stat ? htmlspecialchars($stat['product_name']) : 'Aguardando dados...' ?>
                    </div>
                </div>
            <?php endfor; ?>
        </div>
    </div>
</section>

<!-- Hidden data para JavaScript ter acesso a TODAS as estatísticas -->
<script>
// Este script injeta TODAS as estatísticas do banco no JavaScript
// Mesmo que só 3 sejam exibidas inicialmente
window.allStatisticsData = <?php echo json_encode(array_map(function($stat) {
    return [
        'value' => (int)$stat['value'],
        'label' => $stat['product_name'],
        'image' => asset($stat['image_url'])
    ];
}, $statistics ?? [])); ?>;

console.log('Dados carregados:', window.allStatisticsData.length, 'estatísticas');
</script>

<section class="production-title">
    <div class="container">
        <h2>Evolução da Produção Anual</h2>
        <p>Crescimento consistente da nossa produção agrícola ao longo dos anos</p>
    </div>
</section>
<!-- Chart Section - Mantido estático -->
<div class="chart-section">
    <div class="chart-container">
        <!-- Y Axis Title -->
        <div class="y-axis-title">Produtividade (Kg)</div>

        <!-- Y Axis -->
        <div class="y-axis">
            <div class="y-label">150</div>
            <div class="y-label">100</div>
            <div class="y-label">50</div>
            <div class="y-label">0</div>
        </div>

        <div class="chart-wrapper">
            <!-- Grid Lines -->
            <div class="grid-lines">
                <div class="grid-line" style="top: 0%;"></div>
                <div class="grid-line" style="top: 33.33%;"></div>
                <div class="grid-line" style="top: 66.66%;"></div>
                <div class="grid-line" style="top: 100%;"></div>
            </div>

            <!-- Bars -->
            <div class="bars-container">
                <div class="bar-wrapper">
                    <div class="bar" style="height: 59.64%;">
                        <div class="bar-value">89.455kg</div>
                    </div>
                </div>
                <div class="bar-wrapper">
                    <div class="bar" style="height: 48.22%;">
                        <div class="bar-value">72.334kg</div>
                    </div>
                </div>
                <div class="bar-wrapper">
                    <div class="bar" style="height: 80.65%;">
                        <div class="bar-value">120.977kg</div>
                    </div>
                </div>
                <div class="bar-wrapper">
                    <div class="bar" style="height: 47.18%;">
                        <div class="bar-value">70.778kg</div>
                    </div>
                </div>
                <div class="bar-wrapper">
                    <div class="bar" style="height: 93.45%;">
                        <div class="bar-value">140.192kg</div>
                    </div>
                </div>
            </div>

            <!-- X Axis -->
            <div class="x-axis">
                <div class="x-label">2020</div>
                <div class="x-label">2021</div>
                <div class="x-label">2022</div>
                <div class="x-label">2023</div>
                <div class="x-label">2024</div>
            </div>
            <div class="x-axis-title">Anos</div>
        </div>
    </div>

    <div class="chart-legend">
        <div class="legend-item">
            <div class="legend-color"></div>
            <div class="legend-text">Produção Total Anual (Kg)</div>
        </div>
    </div>
</div>
<br><br>

<!-- Incluir FOOTER -->
<?php include APP_PATH . '/views/partials/footer.php'; ?>