<!-- Modern Navbar -->
<nav class="modern-navbar">
    <div class="container">
        <div class="navbar-container">
            <div class="logo-section">
                <?php if (isset($header) && $header): ?>
                <a href="<?= url('/home') ?>">
                    <img src="<?= asset('images/logo.png') ?>" 
                         alt="<?= htmlspecialchars($header['logo_alt'] ?? 'Baobab Zambeze Farm') ?>" 
                         width="<?= $header['logo_width'] ?? 50 ?>" 
                         height="<?= $header['logo_height'] ?? 50 ?>">
                </a>
                <?php else: ?>
                <a href="<?= url('/home') ?>">
                    <img src="<?= asset('images/logo.png') ?>" alt="Baobab Zambeze Farm" width="50" height="50">
                </a>
                <?php endif; ?>
            </div>

            <ul class="nav-menu" id="navMenu">
                <?php if (isset($menu_items) && !empty($menu_items)): ?>
                    <?php foreach ($menu_items as $item): ?>
                        <?php
                        // Extrair o nome da página da URL (ex: about.html -> about, /home -> home)
                        $item_page = basename($item['url'], '.html');
                        $item_page = str_replace(['/', '.php'], '', $item_page);
                        
                        // Verificar se é a página atual
                        $is_active = (isset($current_page) && $current_page === $item_page) ? 'active' : '';
                        ?>
                        <li>
                            <a href="<?= url('/' . $item_page) ?>" 
                               class="nav-link <?= $is_active ?>">
                                <?= htmlspecialchars($item['label']) ?>
                            </a>
                        </li>
                    <?php endforeach; ?>
                <?php else: ?>
                    <!-- Menu padrão caso não haja dados no banco -->
                    <li><a href="<?= url('/home') ?>" class="nav-link <?= (isset($current_page) && $current_page === 'home') ? 'active' : '' ?>">Sobre Nós</a></li>
                    <li><a href="<?= url('/production') ?>" class="nav-link <?= (isset($current_page) && $current_page === 'production') ? 'active' : '' ?>">Produção</a></li>
                    <li><a href="<?= url('/activities') ?>" class="nav-link <?= (isset($current_page) && $current_page === 'activities') ? 'active' : '' ?>">Actividades</a></li>
                    <li><a href="<?= url('/contact') ?>" class="nav-link <?= (isset($current_page) && $current_page === 'contact') ? 'active' : '' ?>">Contacto</a></li>
                <?php endif; ?>
            </ul>

            <button class="mobile-menu-toggle" onclick="toggleMobileMenu()">
                <i class="fas fa-bars"></i>
            </button>
        </div>
    </div>
</nav>