<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <?php if (isset($head) && $head): ?>
    <!-- Meta Tags -->
    <meta name="description" content="<?= htmlspecialchars($head['meta_description'] ?? '') ?>">
    <meta name="keywords" content="<?= htmlspecialchars($head['meta_keywords'] ?? '') ?>">
    <meta name="author" content="<?= htmlspecialchars($head['meta_author'] ?? '') ?>">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?= htmlspecialchars($head['og_url'] ?? '') ?>">
    <meta property="og:title" content="<?= htmlspecialchars($head['og_title'] ?? '') ?>">
    <meta property="og:description" content="<?= htmlspecialchars($head['og_description'] ?? '') ?>">
    <meta property="og:image" content="<?= htmlspecialchars($head['og_image'] ?? '') ?>">
    <meta property="og:image:alt" content="Logo da Baobab Zambeze Farm">
    <meta property="og:locale" content="pt_PT">
    <meta property="og:site_name" content="Baobab Zambeze Farm">
    
    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="<?= htmlspecialchars($head['og_url'] ?? '') ?>">
    <meta property="twitter:title" content="<?= htmlspecialchars($head['twitter_title'] ?? '') ?>">
    <meta property="twitter:description" content="<?= htmlspecialchars($head['twitter_description'] ?? '') ?>">
    <meta property="twitter:image" content="<?= htmlspecialchars($head['twitter_image'] ?? '') ?>">
    
    <!-- Canonical URL -->
    <link rel="canonical" href="<?= htmlspecialchars($head['canonical_url'] ?? '') ?>">
    
    <title><?= htmlspecialchars($head['page_title'] ?? 'Baobab Zambeze Farm') ?></title>
    <?php else: ?>
    <title>Baobab Zambeze Farm</title>
    <?php endif; ?>
    
    <!-- CSS Files -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    
    <!-- Favicon -->
    <?php if (isset($head['favicon_url']) && $head['favicon_url']): ?>
    <link rel="shortcut icon" href="<?= htmlspecialchars($head['favicon_url']) ?>" type="image/x-icon">
    <link rel="icon" href="<?= htmlspecialchars($head['favicon_url']) ?>" type="image/png">
    <link rel="apple-touch-icon" href="<?= htmlspecialchars($head['favicon_url']) ?>">
    <?php else: ?>
    <link rel="shortcut icon" href="<?= asset('images/logo.png') ?>" type="image/x-icon">
    <link rel="icon" href="<?= asset('images/logo.png') ?>" type="image/png">
    <link rel="apple-touch-icon" href="<?= asset('images/logo.png') ?>">
    <?php endif; ?>
    
    <!-- Page Specific CSS -->
    <?php if (isset($page_css)): ?>
    <link rel="stylesheet" href="<?= asset('css/' . $page_css) ?>">
    <?php endif; ?>
</head>
<body></body>