<?php
/**
 * VIEW: home/index.php
 * Página Principal - Sobre Nós
 */

// CSS e JS específicos desta página
$page_css = 'app.css';
$page_js = 'about.js';

// Incluir HEAD
include APP_PATH . '/views/partials/head.php';
?>

<!-- Incluir HEADER -->
<?php include APP_PATH . '/views/partials/header.php'; ?>

<!-- Hero Section with Custom Carousel -->
<section class="hero-section">
    <div class="custom-carousel" id="heroCarousel">
        <?php if (!empty($carousel_images)): ?>
            <?php foreach ($carousel_images as $index => $image): ?>
                <div class="carousel-slide <?= $index === 0 ? 'active' : '' ?>">
                    <img src="<?= htmlspecialchars($image['image_url']) ?>" 
                         alt="<?= htmlspecialchars($image['image_alt']) ?>">
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <!-- Imagens padrão caso não haja no banco -->
            <div class="carousel-slide active">
                <img src="<?= asset('images/slider-1.jpg') ?>" alt="Baobab Zambeze Farm">
            </div>
            <div class="carousel-slide">
                <img src="<?= asset('images/slider-2.jpg') ?>" alt="Localização da Farm">
            </div>
            <div class="carousel-slide">
                <img src="<?= asset('images/slider-3.jpg') ?>" alt="Cultivos da Farm">
            </div>
        <?php endif; ?>
    </div>

    <div class="hero-overlay"></div>

    <div class="hero-content">
        <h1 class="hero-title" id="heroTitle">
            <?= isset($page['hero_title']) ? htmlspecialchars($page['hero_title']) : 'Quem somos?' ?>
        </h1>
        <p class="hero-subtitle" id="heroSubtitle">
            <?= isset($page['hero_subtitle']) ? nl2br(htmlspecialchars($page['hero_subtitle'])) : 'Somos a Baobab Zambeze Farm cultivamos na terra, com a gente da terra, para o povo da terra.' ?>
        </p>
    </div>

    <!-- Carousel Navigation -->
    <div class="carousel-nav">
        <button class="carousel-btn" onclick="prevSlide()">
            <i class="fas fa-chevron-left"></i>
        </button>
        <button class="carousel-btn" onclick="nextSlide()">
            <i class="fas fa-chevron-right"></i>
        </button>
    </div>

    <!-- Carousel Indicators -->
    <div class="carousel-indicators d-none">
        <?php 
        $imageCount = !empty($carousel_images) ? count($carousel_images) : 3;
        for ($i = 0; $i < $imageCount; $i++): 
        ?>
            <div class="indicator <?= $i === 0 ? 'active' : '' ?>" onclick="goToSlide(<?= $i ?>)"></div>
        <?php endfor; ?>
    </div>
</section>

<!-- Cards Section -->
<section class="cards-section">
    <div class="container top-card">
        <div class="card-grid">
            <!-- Card Missão -->
            <div class="modern-card fade-in">
                <div class="card-header">
                    <h3 class="card-title">
                        <?= isset($page['mission_title']) ? htmlspecialchars($page['mission_title']) : 'Missão' ?>
                    </h3>
                </div>
                <div class="card-content">
                    <p class="card-text">
                        <?= isset($page['mission_content']) ? nl2br(htmlspecialchars($page['mission_content'])) : 'Prover alimentos de alta qualidade e sustentabilidade, promovendo o desenvolvimento da agricultura local e contribuir para a segurança alimentar das comunidades usando práticas ambientalmente responsáveis.' ?>
                    </p>
                </div>
            </div>

            <!-- Card Visão -->
            <div class="modern-card fade-in">
                <div class="card-header">
                    <h3 class="card-title">
                        <?= isset($page['vision_title']) ? htmlspecialchars($page['vision_title']) : 'Visão' ?>
                    </h3>
                </div>
                <div class="card-content">
                    <p class="card-text">
                        <?= isset($page['vision_content']) ? nl2br(htmlspecialchars($page['vision_content'])) : 'Ser referência local e quiçá nacional em produção agrícola sustentável, reconhecida pela qualidade dos produtos, inovação tecnológica e contributo para o compromisso econômico e social.' ?>
                    </p>
                </div>
            </div>

            <!-- Card Valores -->
            <div class="modern-card fade-in">
                <div class="card-header">
                    <h3 class="card-title">
                        <?= isset($page['values_title']) ? htmlspecialchars($page['values_title']) : 'Valores' ?>
                    </h3>
                </div>
                <div class="card-content">
                    <div class="card-text">
                        <?php if (isset($page['values_array']) && !empty($page['values_array'])): ?>
                            <?php foreach ($page['values_array'] as $value): ?>
                                <div><?= htmlspecialchars($value) ?></div>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <!-- Valores padrão -->
                            <div>Qualidade</div>
                            <div>Inovação</div>
                            <div>Sustentabilidade</div>
                            <div>Responsabilidade Social</div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- History Section -->
<section class="history-section"  style="background-image: linear-gradient(rgba(0, 0, 0, 0.7), rgba(0, 0, 0, 0.7)), url('<?php echo ASSETS_URL; ?>/images/bg-history.jpg');">
    <div class="container">
        <div class="history-content">
            <h2 class="history-title">
                <?= isset($page['history_title']) ? htmlspecialchars($page['history_title']) : 'Nossa História' ?>
            </h2>
            <div class="history-text">
                <?php if (isset($page['history_content'])): ?>
                    <?= nl2br(htmlspecialchars($page['history_content'])) ?>
                <?php else: ?>
                    <!-- Texto padrão da história -->
                    <p>Foi a cerca de 5 anos que um jovem local movido pela paixão pela agricultura, pelo desejo de empreender, apreço pela autorrealização e utilidade social, decidiu investir nesse sector que sempre foi uma parte fundamentalmente da economia de Moçambique. Assim, o entusiasmo levou o jovem a adquirir terras localizadas no povoado de Kaunge, no distrito de Moatize, a poucos metros a direita da EN9, inicialmente numa área de cerca de 25.000 metros quadrados apenas.</p>

                    <p>Primeiramente enfrentou vários desafios, incluindo a escassez de recursos financeiros e a necessidade de adaptar-se aos desafios de infraestrutura, equipamentos e sistemas de irrigação para a prática agrícola.</p>

                    <p>Nos primeiros anos a farma dedicou-se fundamentalmente ao cultivo da alface e do tomate, sendo que, o alvo comercial principal eram os mercados e algumas empresas ou instâncias locais.</p>

                    <p>Hoje ocupando uma área de aproximadamente 6 hectares, o impacto gratificante directo e notável da farma é a criação de empregos a nível local, a redução da insuficiência alimentar a nível da população local.</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>

<!-- Incluir FOOTER -->
<?php include APP_PATH . '/views/partials/footer.php'; ?>