<?php
/**
 * VIEW: contact/index.php
 * Página de Contacto
 */

// CSS e JS específicos desta página
$page_css = 'contact.css';

// Incluir HEAD
include APP_PATH . '/views/partials/head.php';
?>

<!-- Incluir HEADER -->
<?php include APP_PATH . '/views/partials/header.php'; ?>

<!-- Hero Section -->
<section class="hero-section" style="background-image: url('<?= asset('images/contact.jpg') ?>');">
    <div class="hero-overlay"></div>
    <div class="hero-content">
        <div class="hero-logo">
            <img src="<?= asset('images/logo.png') ?>" alt="Baobab Zambeze Farm">
        </div>
        <h1 class="hero-title">
            <?= isset($page['hero_title']) ? htmlspecialchars($page['hero_title']) : 'Fale Connosco' ?>
        </h1>
    </div>
</section>

<!-- Contact Section -->
<section class="contact-section">
    <div class="container" style="max-width: 1200px;">
        <div class="row">
            <!-- Contact Form -->
            <div class="col-lg-7">
                <div class="contact-form">
                    
                    <?php
                    // Mostrar mensagem de sucesso
                    if (isset($_GET['success']) && $_GET['success'] == '1'):
                    ?>
                        <div class="alert alert-success" style="padding: 15px; margin-bottom: 20px; background-color: #d4edda; border: 1px solid #c3e6cb; border-radius: 5px; color: #155724;">
                            <strong>✓ Sucesso!</strong> Mensagem enviada com sucesso! Entraremos em contacto em breve.
                        </div>
                    <?php endif; ?>
                    
                    <?php
                    // Mostrar mensagem de erro
                    if (isset($_GET['error'])):
                        $errorMsg = '';
                        if ($_GET['error'] == 'validation') {
                            $errorMsg = 'Por favor, preencha todos os campos obrigatórios corretamente.';
                        } elseif ($_GET['error'] == 'database') {
                            $errorMsg = 'Erro ao enviar mensagem. Tente novamente mais tarde.';
                        }
                        if ($errorMsg):
                    ?>
                        <div class="alert alert-danger" style="padding: 15px; margin-bottom: 20px; background-color: #f8d7da; border: 1px solid #f5c6cb; border-radius: 5px; color: #721c24;">
                            <strong>✗ Erro!</strong> <?= htmlspecialchars($errorMsg) ?>
                        </div>
                    <?php 
                        endif;
                    endif; 
                    ?>
                    
                    <form id="contactForm" method="POST" action="<?= url('/contact/submit') ?>">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="first_name">Nome *</label>
                                    <input type="text" 
                                           id="first_name" 
                                           name="first_name" 
                                           value="<?= old('first_name') ?>"
                                           required>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="last_name">Apelido *</label>
                                    <input type="text" 
                                           id="last_name" 
                                           name="last_name" 
                                           value="<?= old('last_name') ?>"
                                           required>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="email">Email *</label>
                            <input type="email" 
                                   id="email" 
                                   name="email" 
                                   value="<?= old('email') ?>"
                                   required>
                        </div>

                        <div class="form-group">
                            <label for="message">Mensagem *</label>
                            <textarea id="message" 
                                      name="message" 
                                      required 
                                      placeholder="Escreva a sua mensagem aqui..."><?= old('message') ?></textarea>
                        </div>

                        <button type="submit" class="submit-btn">
                            <i class="fas fa-paper-plane"></i> Enviar Mensagem
                        </button>
                    </form>
                </div>
            </div>

            <!-- Contact Info -->
            <div class="col-lg-5">
                <div class="contact-info">
                    <div class="info-card">
                        <i class="fas fa-map-marker-alt"></i>
                        <h3>
                            <?= isset($page['location_title']) ? htmlspecialchars($page['location_title']) : 'Localização' ?>
                        </h3>
                        <?php if (isset($page['location_content'])): ?>
                            <?= nl2br(htmlspecialchars($page['location_content'])) ?>
                        <?php else: ?>
                            <p><strong>Baobab Zambeze Farm</strong></p>
                            <p>Povoado de Kaunge</p>
                            <p>Distrito de Moatize</p>
                            <p>Província de Tete, Moçambique</p>
                            <p>EN9 - A caminho da Zâmbia</p>
                        <?php endif; ?>
                    </div>

                    <div class="info-card">
                        <i class="fas fa-envelope"></i>
                        <h3>
                            <?= isset($page['email_title']) ? htmlspecialchars($page['email_title']) : 'Email' ?>
                        </h3>
                        <?php if (isset($page['email_content'])): ?>
                            <p><?= htmlspecialchars($page['email_content']) ?></p>
                        <?php else: ?>
                            <p>info@baobabzambezefarm.mz</p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Gallery Section -->
<br>
<div class="gallery" id="gallery"></div>

<!-- Controles de paginação -->
<div id="pagination" style="text-align:center; margin: 20px 0;"></div>

<!-- Modal -->
<div class="modal" id="modal">
    <span class="close" onclick="closeModal()">&times;</span>
    <img class="modal-content" id="modalImg">
</div>

<script>
    // ==========================
    // 🔹 1. Dados vindos do PHP
    // ==========================
    const photos = <?php 
        if (!empty($gallery_photos)) {
            echo json_encode(array_map(function($photo) {
                return [
                    'url'   => asset($photo['url_imagem']),
                    'title' => $photo['titulo'],
                    'date'  => date('F Y', strtotime($photo['data_foto'] ?? 'now')),
                    'size'  => $photo['tamanho_layout']
                ];
            }, $gallery_photos), JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
        } else {
            echo '[]';
        }
    ?>;

    const gallery = document.getElementById('gallery');
    const pagination = document.getElementById('pagination');

    // ==========================
    // 🔹 2. Configurações
    // ==========================
    const itemsPerPage = 8; // 🔸 número de fotos por página
    let currentPage = 1;
    const totalPages = Math.ceil(photos.length / itemsPerPage);

    // ==========================
    // 🔹 3. Renderizar galeria
    // ==========================
    function renderGallery(page = 1) {
        gallery.innerHTML = ""; // limpa galeria antes de renderizar nova página

        const start = (page - 1) * itemsPerPage;
        const end = start + itemsPerPage;
        const currentPhotos = photos.slice(start, end);

        if (currentPhotos.length === 0) {
            gallery.innerHTML = `
                <div style="text-align: center; padding: 40px; color: #5f6368;">
                    <p style="font-size: 18px; margin-bottom: 10px;">Nenhuma foto disponível no momento.</p>
                </div>
            `;
            pagination.innerHTML = "";
            return;
        }

        currentPhotos.forEach(photo => {
            const item = document.createElement('div');
            item.className = `gallery-item ${photo.size}`;
            item.innerHTML = `
                <img src="${photo.url}" alt="${photo.title}" 
                     onerror="console.error('Erro ao carregar:', '${photo.url}')">
                <div class="overlay">
                    <div class="overlay-title">${photo.title}</div>
                    <div class="overlay-date">${photo.date}</div>
                </div>
            `;
            item.onclick = () => openModal(photo.url);
            gallery.appendChild(item);
        });

        renderPagination(page);
    }

    // ==========================
    // 🔹 4. Renderizar paginação
    // ==========================
    function renderPagination(page) {
        let buttonsHTML = '';

        // Botão anterior
        if (page > 1) {
            buttonsHTML += `<button onclick="changePage(${page - 1})">Anterior</button>`;
        }

        // Mostra número da página atual e total
        buttonsHTML += `<span style="margin: 0 10px;">Página ${page} de ${totalPages}</span>`;

        // Botão próximo
        if (page < totalPages) {
            buttonsHTML += `<button onclick="changePage(${page + 1})">Próxima</button>`;
        }

        pagination.innerHTML = buttonsHTML;
    }

    // ==========================
    // 🔹 5. Mudar de página
    // ==========================
    function changePage(newPage) {
        currentPage = newPage;
        renderGallery(currentPage);

        // scroll suave até o topo da galeria
        window.scrollTo({ top: gallery.offsetTop - 50, behavior: 'smooth' });
    }

    // ==========================
    // 🔹 6. Modal
    // ==========================
    function openModal(imgSrc) {
        const modal = document.getElementById('modal');
        const modalImg = document.getElementById('modalImg');
        modal.classList.add('active');
        modalImg.src = imgSrc;
        document.body.style.overflow = 'hidden';
    }

    function closeModal() {
        const modal = document.getElementById('modal');
        modal.classList.remove('active');
        document.body.style.overflow = 'auto';
    }

    document.getElementById('modal').onclick = function(e) {
        if (e.target === this) {
            closeModal();
        }
    };

    document.addEventListener('keydown', function(e) {
        if (e.key === 'Escape') {
            closeModal();
        }
    });

    // ==========================
    // 🔹 7. Inicializar
    // ==========================
    renderGallery(currentPage);
</script>


<!-- Incluir FOOTER -->
<?php include APP_PATH . '/views/partials/footer.php'; ?>