<?php
/**
 * VIEW: activities/index.php
 * Página de Actividades
 */

// CSS e JS específicos desta página
$page_css = 'activity.css';
$page_js = 'activity.js';

// Incluir HEAD
include APP_PATH . '/views/partials/head.php';
?>

<!-- Incluir HEADER -->
<?php include APP_PATH . '/views/partials/header.php'; ?>

<!-- Hero Section -->
<section class="hero-section" id="heroSection">
    <!-- Left - Image Slider -->
    <div class="hero-left">
        <div class="slider-wrapper">
            <?php if (!empty($slides)): ?>
                <!-- Slide Inicial (Primeira imagem) -->
                <div class="carousel-slide active" data-slide="inicial">
                    <img src="<?= asset(htmlspecialchars($slides[0]['image_url'])); ?>" 
                         alt="<?= htmlspecialchars($slides[0]['image_alt']) ?>">
                    <div class="hero-overlay"></div>
                </div>
                
                <?php foreach ($slides as $index => $slide): ?>
                    <div class="carousel-slide" data-slide="<?= $index ?>">
                        <img src="<?= asset(htmlspecialchars($slide['image_url'])); ?>" 
                             alt="<?= htmlspecialchars($slide['image_alt']) ?>">
                        <div class="hero-overlay"></div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>

        <?php if (!empty($slides)): ?>
        <!-- Navigation Arrows -->
        <div class="slider-nav">
            <button class="slider-btn prev" onclick="prevSlide()">
                <i class="fas fa-chevron-left"></i>
            </button>
            <button class="slider-btn next" onclick="nextSlide()">
                <i class="fas fa-chevron-right"></i>
            </button>
        </div>
        <?php endif; ?>
    </div>

    <!-- Right - Text Content -->
    <div class="hero-right">
        <div class="hero-content">
            <?php if (!empty($slides)): ?>
                <!-- Content Inicial -->
                <div class="content-slide active" data-content="inicial">
                    <h1>
                        <?= isset($page['hero_initial_title']) ? htmlspecialchars($page['hero_initial_title']) : 'Nossas Actividades' ?>
                    </h1>
                    <p>
                        <?= isset($page['hero_initial_subtitle']) ? nl2br(htmlspecialchars($page['hero_initial_subtitle'])) : 'Na Baobab Zambeze Farm, desenvolvemos práticas sociais e agrícolas sustentáveis.' ?>
                    </p>
                </div>
                
                <?php foreach ($slides as $index => $slide): ?>
                    <div class="content-slide" data-content="<?= $index ?>">
                        <h1><?= htmlspecialchars($slide['title']) ?></h1>
                        <p><?= nl2br(htmlspecialchars($slide['description'])) ?></p>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <!-- Conteúdo quando não há slides -->
                <div class="content-slide active" data-content="inicial">
                    <h1>Nossas Actividades</h1>
                    <p>Na Baobab Zambeze Farm, desenvolvemos práticas sociais e agrícolas sustentáveis, promovendo a transferência de conhecimento e tecnologia para a comunidade.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</section>

<?php if (!empty($social_cards)): ?>
<!-- Práticas Sociais Section -->
<section class="section-title">
    <div class="container">
        <h2>
            <?= isset($page['social_practices_title']) ? htmlspecialchars($page['social_practices_title']) : 'Práticas Sociais' ?>
        </h2>
    </div>
</section>

<section class="activities-section">
    <div class="container">
        <div class="activities-grid">
            <?php foreach ($social_cards as $card): ?>
                <div class="activity-card" 
                     <?php if ($card['linked_slide_number'] !== null): ?>
                     onclick="goToActivity(<?= $card['linked_slide_number'] ?>)"
                     <?php endif; ?>>
                    <div class="activity-image">
                        <img src="<?= asset(htmlspecialchars($card['image_url'])); ?>" 
                             alt="<?= htmlspecialchars($card['image_alt']) ?>">
                        <div class="activity-overlay"></div>
                    </div>
                    <div class="activity-content">
                        <h3 class="activity-title"><?= htmlspecialchars($card['card_title']) ?></h3>
                        <?php if ($card['linked_slide_number'] !== null): ?>
                        <button class="btn-saiba-mais">Saiba Mais <i class="fas fa-arrow-up"></i></button>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>
<?php endif; ?>

<?php if (!empty($agricultural_cards)): ?>
<!-- Práticas Agrícolas Section -->
<section class="section-title">
    <div class="container">
        <h2>
            <?= isset($page['agricultural_practices_title']) ? htmlspecialchars($page['agricultural_practices_title']) : 'Processos Agrícolas' ?>
        </h2>
    </div>
</section>

<section class="activities-section">
    <div class="container">
        <div class="activities-grid">
            <?php foreach ($agricultural_cards as $card): ?>
                <div class="activity-card" 
                     <?php if ($card['linked_slide_number'] !== null): ?>
                     onclick="goToActivity(<?= $card['linked_slide_number'] ?>)"
                     <?php endif; ?>>
                    <div class="activity-image">
                        <img src="<?= asset(htmlspecialchars($card['image_url'])); ?>" 
                             alt="<?= htmlspecialchars($card['image_alt']) ?>">
                        <div class="activity-overlay"></div>
                    </div>
                    <div class="activity-content">
                        <h3 class="activity-title"><?= htmlspecialchars($card['card_title']) ?></h3>
                        <?php if ($card['linked_slide_number'] !== null): ?>
                        <button class="btn-saiba-mais">Saiba Mais <i class="fas fa-arrow-up"></i></button>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Incluir FOOTER -->
<?php include APP_PATH . '/views/partials/footer.php'; ?>