<?php
/**
 * MODEL: PageFooter
 * Gerencia as informações do rodapé
 */
class PageFooter {
    private $db;
    
    public function __construct() {
        $this->db = Database::getInstance();
    }
    
    public function getFooter() {
        $sql = "SELECT * FROM page_footer LIMIT 1";
        $stmt = $this->db->query($sql);
        return $stmt ? $stmt->fetch() : null;
    }
    
    public function getPolicyLinks($footerId = null) {
        if ($footerId === null) {
            $footer = $this->getFooter();
            $footerId = $footer['id'] ?? 1;
        }
        
        $sql = "SELECT * FROM footer_policy_links 
                WHERE footer_id = ? 
                ORDER BY display_order";
        $stmt = $this->db->query($sql, [$footerId]);
        return $stmt ? $stmt->fetchAll() : [];
    }
    
    public function getSocialLinks($footerId = null) {
        if ($footerId === null) {
            $footer = $this->getFooter();
            $footerId = $footer['id'] ?? 1;
        }
        
        $sql = "SELECT * FROM footer_social_links 
                WHERE footer_id = ? 
                ORDER BY display_order";
        $stmt = $this->db->query($sql, [$footerId]);
        return $stmt ? $stmt->fetchAll() : [];
    }
    
    public function update($id, $data) {
        $sql = "UPDATE page_footer SET 
            policies_title = ?, social_title = ?, contacts_title = ?,
            company_name = ?, address_line1 = ?, address_line2 = ?, 
            address_line3 = ?, address_line4 = ?,
            phone1 = ?, phone2 = ?, email_primary = ?, email_secondary = ?,
            copyright_text = ?
            WHERE id = ?";
        
        return $this->db->query($sql, [
            $data['policies_title'],
            $data['social_title'],
            $data['contacts_title'],
            $data['company_name'],
            $data['address_line1'],
            $data['address_line2'],
            $data['address_line3'],
            $data['address_line4'],
            $data['phone1'],
            $data['phone2'],
            $data['email_primary'],
            $data['email_secondary'],
            $data['copyright_text'],
            $id
        ]);
    }
}