<?php

/**
 * MODEL: PageContact
 * Gerencia a página de Contacto
 */
class PageContact {
    private $db;
    
    public function __construct() {
        $this->db = Database::getInstance();
    }
    
    /**
     * Buscar dados da página de contacto
     */
    public function getByPageIdentifier($pageIdentifier) {
        $sql = "SELECT * FROM page_contact WHERE page_identifier = ? AND is_active = 1 LIMIT 1";
        $stmt = $this->db->query($sql, [$pageIdentifier]);
        return $stmt ? $stmt->fetch() : null;
    }
    
    /**
     * Buscar todas as fotos da galeria
     * Usa activities_id = 1 para a página de contacto
     */
    public function getGalleryPhotos() {
        $sql = "SELECT 
                    id,
                    activities_id,
                    titulo,
                    descricao,
                    url_imagem,
                    url_thumbnail,
                    tamanho_layout,
                    data_foto,
                    data_upload,
                    largura,
                    altura,
                    tamanho_arquivo,
                    formato,
                    ativo,
                    visualizacoes
                FROM fotos 
                WHERE activities_id = 1 AND ativo = 1 
                ORDER BY data_foto DESC";
        $stmt = $this->db->query($sql);
        return $stmt ? $stmt->fetchAll() : [];
    }
    
    /**
     * Buscar fotos por tamanho de layout
     */
    public function getPhotosByLayout($layout) {
        $sql = "SELECT * FROM fotos 
                WHERE activities_id = 1 
                AND tamanho_layout = ? 
                AND ativo = 1 
                ORDER BY data_foto DESC";
        $stmt = $this->db->query($sql, [$layout]);
        return $stmt ? $stmt->fetchAll() : [];
    }
    
    /**
     * Buscar foto específica por ID
     */
    public function getPhotoById($id) {
        $sql = "SELECT * FROM fotos WHERE id = ? AND ativo = 1 LIMIT 1";
        $stmt = $this->db->query($sql, [$id]);
        return $stmt ? $stmt->fetch() : null;
    }
    
    /**
     * Incrementar visualizações da foto
     */
    public function incrementPhotoViews($id) {
        $sql = "UPDATE fotos SET visualizacoes = visualizacoes + 1 WHERE id = ?";
        return $this->db->query($sql, [$id]);
    }
    
    /**
     * Contar total de fotos
     */
    public function getTotalPhotos() {
        $sql = "SELECT COUNT(*) as total FROM fotos 
                WHERE activities_id = 1 AND ativo = 1";
        $stmt = $this->db->query($sql);
        $result = $stmt ? $stmt->fetch() : null;
        return $result ? $result['total'] : 0;
    }
    
    /**
     * Salvar mensagem de contacto
     */
    public function saveMessage($data) {
        $sql = "INSERT INTO contact_messages (first_name, last_name, email, message, created_at)
                VALUES (?, ?, ?, ?, NOW())";
        
        return $this->db->query($sql, [
            $data['first_name'],
            $data['last_name'],
            $data['email'],
            $data['message']
        ]);
    }
    
    /**
     * Buscar estatísticas da galeria
     */
    public function getGalleryStats() {
        $sql = "SELECT 
                    COUNT(*) as total_photos,
                    SUM(visualizacoes) as total_views,
                    MAX(data_upload) as last_upload,
                    tamanho_layout,
                    COUNT(*) as count_by_size
                FROM fotos 
                WHERE activities_id = 1 AND ativo = 1
                GROUP BY tamanho_layout";
        $stmt = $this->db->query($sql);
        return $stmt ? $stmt->fetchAll() : [];
    }
}