<?php

/**
 * MODEL: PageActivities
 * Gerencia a página de Actividades
 */
class PageActivities
{
    private $db;

    public function __construct()
    {
        $this->db = Database::getInstance();
    }

    public function getByPageIdentifier($pageIdentifier)
    {
        $sql = "SELECT * FROM page_activities WHERE page_identifier = ? AND is_active = 1 LIMIT 1";
        $stmt = $this->db->query($sql, [$pageIdentifier]);
        return $stmt ? $stmt->fetch() : null;
    }

    public function getSlides($activitiesId)
    {
        $sql = "SELECT * FROM activities_slides 
                WHERE activities_id = ? AND is_active = 1 
                ORDER BY slide_number";
        $stmt = $this->db->query($sql, [$activitiesId]);
        return $stmt ? $stmt->fetchAll() : [];
    }

    public function getCards($activitiesId, $category = null)
    {
        if ($category) {
            $sql = "SELECT * FROM activities_cards 
                    WHERE activities_id = ? AND category = ? AND is_active = 1 
                    ORDER BY display_order";
            $stmt = $this->db->query($sql, [$activitiesId, $category]);
        } else {
            $sql = "SELECT * FROM activities_cards 
                    WHERE activities_id = ? AND is_active = 1 
                    ORDER BY category, display_order";
            $stmt = $this->db->query($sql, [$activitiesId]);
        }
        return $stmt ? $stmt->fetchAll() : [];
    }

    public function update($id, $data)
    {
        $sql = "UPDATE page_activities SET 
            hero_initial_title = ?, hero_initial_subtitle = ?,
            social_practices_title = ?, agricultural_practices_title = ?
            WHERE id = ?";

        return $this->db->query($sql, [
            $data['hero_initial_title'],
            $data['hero_initial_subtitle'],
            $data['social_practices_title'],
            $data['agricultural_practices_title'],
            $id
        ]);
    }

}
