<?php
/**
 * MODEL: LayoutHead
 * Gerencia os metadados e informações do <head>
 */
class LayoutHead {
    private $db;
    
    public function __construct() {
        $this->db = Database::getInstance();
    }
    
    public function getByPageIdentifier($pageIdentifier) {
        $sql = "SELECT * FROM layout_head WHERE page_identifier = ? LIMIT 1";
        $stmt = $this->db->query($sql, [$pageIdentifier]);
        return $stmt ? $stmt->fetch() : null;
    }
    
    public function getAll() {
        $sql = "SELECT * FROM layout_head ORDER BY page_identifier";
        $stmt = $this->db->query($sql);
        return $stmt ? $stmt->fetchAll() : [];
    }
    
    public function create($data) {
        $sql = "INSERT INTO layout_head (
            page_identifier, page_title, meta_description, meta_keywords, meta_author,
            og_title, og_description, og_image, og_url, 
            twitter_title, twitter_description, twitter_image,
            canonical_url, favicon_url
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        
        return $this->db->query($sql, [
            $data['page_identifier'],
            $data['page_title'],
            $data['meta_description'],
            $data['meta_keywords'],
            $data['meta_author'],
            $data['og_title'],
            $data['og_description'],
            $data['og_image'],
            $data['og_url'],
            $data['twitter_title'],
            $data['twitter_description'],
            $data['twitter_image'],
            $data['canonical_url'],
            $data['favicon_url']
        ]);
    }
    
    public function update($id, $data) {
        $sql = "UPDATE layout_head SET 
            page_title = ?, meta_description = ?, meta_keywords = ?, meta_author = ?,
            og_title = ?, og_description = ?, og_image = ?, og_url = ?,
            twitter_title = ?, twitter_description = ?, twitter_image = ?,
            canonical_url = ?, favicon_url = ?
            WHERE id = ?";
        
        return $this->db->query($sql, [
            $data['page_title'],
            $data['meta_description'],
            $data['meta_keywords'],
            $data['meta_author'],
            $data['og_title'],
            $data['og_description'],
            $data['og_image'],
            $data['og_url'],
            $data['twitter_title'],
            $data['twitter_description'],
            $data['twitter_image'],
            $data['canonical_url'],
            $data['favicon_url'],
            $id
        ]);
    }
}