<?php

class ProductionController {
    private $layoutHeadModel;
    private $layoutHeaderModel;
    private $pageProductionModel;
    private $pageFooterModel;
    
    public function __construct() {
        $this->layoutHeadModel = new LayoutHead();
        $this->layoutHeaderModel = new LayoutHeader();
        $this->pageProductionModel = new PageProduction();
        $this->pageFooterModel = new PageFooter();
    }
    
    public function index() {
        // Buscar dados do HEAD
        $headData = $this->layoutHeadModel->getByPageIdentifier('production');
        
        // Buscar dados do HEADER
        $headerData = $this->layoutHeaderModel->getHeader();
        $menuItems = $this->layoutHeaderModel->getMenuItems();
        
        // Buscar dados da página PRODUCTION
        $pageData = $this->pageProductionModel->getByPageIdentifier('production');
        $carouselImages = [];
        $productsCard1 = [];
        $productsCard2 = [];
        $productsCard3 = [];
        $statistics = [];
        
        if ($pageData) {
            // Buscar imagens do carousel
            $carouselImages = $this->pageProductionModel->getCarouselImages($pageData['id']);
            
            // Buscar produtos por card
            $productsCard1 = $this->pageProductionModel->getProductsByCard($pageData['id'], 1);
            $productsCard2 = $this->pageProductionModel->getProductsByCard($pageData['id'], 2);
            $productsCard3 = $this->pageProductionModel->getProductsByCard($pageData['id'], 3);
            
            // Buscar estatísticas
            $statistics = $this->pageProductionModel->getStatistics($pageData['id']);
        }
        
        // Buscar dados do FOOTER
        $footerData = $this->pageFooterModel->getFooter();
        $policyLinks = $this->pageFooterModel->getPolicyLinks();
        $socialLinks = $this->pageFooterModel->getSocialLinks();
        
        // Passar dados para a view
        $data = [
            'head' => $headData,
            'header' => $headerData,
            'menu_items' => $menuItems,
            'page' => $pageData,
            'carousel_images' => $carouselImages,
            'products_card1' => $productsCard1,
            'products_card2' => $productsCard2,
            'products_card3' => $productsCard3,
            'statistics' => $statistics,
            'footer' => $footerData,
            'policy_links' => $policyLinks,
            'social_links' => $socialLinks,
            'current_page' => 'production'
        ];
        
        view('production/index', $data);
    }
}