<?php

class HomeController {
    private $layoutHeadModel;
    private $layoutHeaderModel;
    private $pageHomeModel;
    private $pageFooterModel;
    
    public function __construct() {
        $this->layoutHeadModel = new LayoutHead();
        $this->layoutHeaderModel = new LayoutHeader();
        $this->pageHomeModel = new PageHome();
        $this->pageFooterModel = new PageFooter();
    }
    
    public function index() {
        // Buscar dados do HEAD
        $headData = $this->layoutHeadModel->getByPageIdentifier('home');
        
        // Buscar dados do HEADER
        $headerData = $this->layoutHeaderModel->getHeader();
        $menuItems = $this->layoutHeaderModel->getMenuItems();
        
        // Buscar dados da página HOME
        $pageData = $this->pageHomeModel->getByPageIdentifier('home');
        $carouselImages = [];
        
        if ($pageData) {
            $carouselImages = $this->pageHomeModel->getCarouselImages($pageData['id']);
            // Decodificar valores JSON
            if (isset($pageData['values_content'])) {
                $pageData['values_array'] = json_decode($pageData['values_content'], true);
            }
        }
        
        // Buscar dados do FOOTER
        $footerData = $this->pageFooterModel->getFooter();
        $policyLinks = $this->pageFooterModel->getPolicyLinks();
        $socialLinks = $this->pageFooterModel->getSocialLinks();
        
        // Passar dados para a view
        $data = [
            'head' => $headData,
            'header' => $headerData,
            'menu_items' => $menuItems,
            'page' => $pageData,
            'carousel_images' => $carouselImages,
            'footer' => $footerData,
            'policy_links' => $policyLinks,
            'social_links' => $socialLinks,
            'current_page' => 'home'
        ];
        
        view('home/index', $data);
    }
}