<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description"
        content="Conheça a história da Baobab Zambeze Farm. Há 5 anos promovendo agricultura sustentável em Kaunge, Tete. Nossa missão, visão e valores na produção agrícola responsável.">
    <meta name="keywords"
        content="Baobab Zambeze Farm, sobre nós, história, missão, visão, valores, Kaunge, Tete, Moçambique, agricultura sustentável">
    <meta name="author" content="Baobab Zambeze Farm">

    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo SITE_URL; ?>">
    <meta property="og:title" content="Sobre Nós - Baobab Zambeze Farm">
    <meta property="og:description"
        content="Cultivamos na terra, com a gente da terra, para o povo da terra. Conheça a nossa história de 5 anos em agricultura sustentável em Tete, Moçambique.">
    <meta property="og:image" content="<?php echo ASSETS_URL; ?>/images/logo.png">
    <meta property="og:image:alt" content="Logo da Baobab Zambeze Farm - Nossa História">
    <meta property="og:locale" content="pt_PT">
    <meta property="og:site_name" content="Baobab Zambeze Farm">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="<?php echo ASSETS_URL; ?>/about.html">
    <meta property="twitter:title" content="Sobre Nós - Baobab Zambeze Farm">
    <meta property="twitter:description"
        content="Cultivamos na terra, com a gente da terra, para o povo da terra. Nossa história em agricultura sustentável em Tete.">
    <meta property="twitter:image" content="<?php echo ASSETS_URL; ?>/images/logo.png">

    <!-- Canonical URL -->
    <link rel="canonical" href="<?php echo SITE_URL; ?>">

    <title>Sobre Nós - Baobab Zambeze Farm</title>
    <link href="<?php echo SITE_URL; ?>/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="<?php echo ASSETS_URL; ?>/css/app.css">
    <link rel="shortcut icon" href="<?php echo ASSETS_URL; ?>/images/logo.png" type="image/x-icon">
    <link rel="icon" href="<?php echo ASSETS_URL; ?>/images/logo.png" type="image/png">
    <link rel="apple-touch-icon" href="<?php echo SITE_URL; ?>/images/logo.png">
</head>

<body>
    <!-- Modern Navbar -->
    <nav class="modern-navbar">
        <div class="container">
            <div class="navbar-container">
                <div class="logo-section">
                    <img src="<?php echo ASSETS_URL; ?>/images/logo.png" alt="Baobab Zambeze Farm" width="50" height="50">
                </div>

                <ul class="nav-menu" id="navMenu">
                    <li><a href="about.html" class="nav-link active">Sobre Nós</a></li>
                    <li><a href="production.html" class="nav-link">Produção</a></li>
                    <li><a href="activities.html" class="nav-link">Actividades</a></li>
                    <li><a href="contact.html" class="nav-link">Contacto</a></li>
                </ul>

                <button class="mobile-menu-toggle" onclick="toggleMobileMenu()">
                    <i class="fas fa-bars"></i>
                </button>
            </div>
        </div>
    </nav>

    <!-- Hero Section with Custom Carousel -->
    <section class="hero-section">
        <div class="custom-carousel" id="heroCarousel">
            <div class="carousel-slide active">
                <img src="<?php echo ASSETS_URL; ?>/images/slider-1.jpg" alt="Baobab Zambeze Farm">
            </div>
            <div class="carousel-slide">
                <img src="<?php echo ASSETS_URL; ?>/images/slider-2.jpg" alt="Localização da Farm">
            </div>
            <div class="carousel-slide">
                <img src="<?php echo ASSETS_URL; ?>/images/slider-3.jpg" alt="Cultivos da Farm">
            </div>
        </div>

        <div class="hero-overlay"></div>

        <div class="hero-content">
            <h1 class="hero-title" id="heroTitle">Quem somos?</h1>
            <p class="hero-subtitle" id="heroSubtitle">Somos a Baobab Zambeze Farm cultivamos na terra, 
                <br>com a gente da terra, para o povo da terra. <br>
                De Kaunge em Tete, para Moçambique.</p>
        </div>

        <!-- Carousel Navigation -->
        <div class="carousel-nav">
            <button class="carousel-btn" onclick="prevSlide()">
                <i class="fas fa-chevron-left"></i>
            </button>
            <button class="carousel-btn" onclick="nextSlide()">
                <i class="fas fa-chevron-right"></i>
            </button>
        </div>

        <!-- Carousel Indicators -->
        <div class="carousel-indicators d-none">
            <div class="indicator active" onclick="goToSlide(0)"></div>
            <div class="indicator" onclick="goToSlide(1)"></div>
            <div class="indicator" onclick="goToSlide(2)"></div>
        </div>
    </section>

    <!-- Cards Section -->
    <section class="cards-section">
        <div class="container top-card">
            <div class="card-grid">
                <div class="modern-card fade-in">
                    <div class="card-header">
                        <h3 class="card-title">Missão</h3>
                    </div>
                    <div class="card-content">
                        <p class="card-text">
                            Prover alimentos de alta qualidade e sustentabilidade, promovendo o desenvolvimento da
                            agricultura local e contribuir para a segurança alimentar das comunidades usando práticas
                            ambientalmente responsáveis.
                        </p>
                    </div>
                </div>

                <div class="modern-card fade-in">
                    <div class="card-header">
                        <h3 class="card-title">Visão</h3>
                    </div>
                    <div class="card-content">
                        <p class="card-text">
                            Ser referência local e quiçá nacional em produção agrícola sustentável, reconhecida pela
                            qualidade dos produtos, inovação tecnológica e contributo para o compromisso econômico e
                            social.
                        </p>
                    </div>
                </div>

                <div class="modern-card fade-in">
                    <div class="card-header">
                        <h3 class="card-title">Valores</h3>
                    </div>
                    <div class="card-content">
                        <div class="card-text">
                            <div>Qualidade</div>
                            <div>Inovação</div>
                            <div>Sustentabilidade</div>
                            <div>Responsabilidade Social</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- History Section -->
    <section class="history-section" style="background-image: linear-gradient(rgba(0, 0, 0, 0.7), rgba(0, 0, 0, 0.7)), url('<?php echo ASSETS_URL; ?>/images/bg-history.jpg');">
        <div class="container">
            <div class="history-content">
                <h2 class="history-title">Nossa História</h2>
                <div class="history-text">
                    <p>Foi a cerca de 5 anos que um jovem local movido pela paixão pela agricultura, pelo desejo de
                        empreender, apreço pela autorrealização e utilidade social, decidiu investir nesse sector que
                        sempre foi uma parte fundamentalmente da economia de Moçambique. Assim, o entusiasmo levou o
                        jovem a adquirir terras localizadas no povoado de Kaunge, no distrito de Moatize, a poucos
                        metros a direita da EN9, inicialmente numa área de cerca de 25.000 metros quadrados apenas.</p>

                    <p>Primeiramente enfrentou vários desafios, incluindo a escassez de recursos financeiros e a
                        necessidade de adaptar-se aos desafios de infraestrutura, equipamentos e sistemas de irrigação
                        para a prática agrícola.</p>

                    <p>Nos primeiros anos a farma dedicou-se fundamentalmente ao cultivo da alface e do tomate, sendo
                        que, o alvo comercial principal eram os mercados e algumas empresas ou instâncias locais.</p>

                    <p>Hoje ocupando uma área de aproximadamente 6 hectares, o impacto gratificante directo e notável da
                        farma é a criação de empregos a nível local, a redução da insuficiência alimentar a nível da
                        população local.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Modern Footer -->
    <footer class="modern-footer">
        <div class="container">
            <div class="footer-grid">
                <div class="footer-section">
                    <h3>Políticas</h3>
                    <a href="/privacy.html" class="footer-link">Políticas de Privacidade</a>
                    <a href="/terms.html" class="footer-link">Termos e Condições</a>
                </div>

                <div class="footer-section">
                    <h3>Redes Sociais</h3>
                    <div class="social-links">
                        <a href="#" class="social-link">
                            <i class="fab fa-facebook-f"></i>
                        </a>
                        <a href="#" class="social-link">
                            <i class="fab fa-instagram"></i>
                        </a>
                    </div>
                </div>

                <div class="footer-section">
                    <h3>Contactos</h3>
                    <div class="footer-text">
                        <p><strong>Baobab Zambeze Farm</strong></p>
                        <p>Povoado de Kaunge, Distrito de Moatize</p>
                        <p>Província de Tete, Moçambique</p>
                        <p>EN9 - A caminho da Zâmbia</p>
                        <p>Email: info@baobabzambezefarm.mz</p>
                    </div>
                </div>
            </div>

            <div class="copyright">
                <div class="container">
                    <p>© 2024 Baobab Zambeze Farm. Todos os direitos reservados. Desenvolvido por Labore</p>
                </div>
            </div>
        </div>
    </footer>

    <script src="<?php echo ASSETS_URL; ?>/js/about.js"></script>
</body>

</html>