let currentSlide = 'inicial'; // Começa no slide inicial

// Função para mostrar slide específico
function showSlide(slideId) {
    // Remove active de todos os slides
    document.querySelectorAll('.carousel-slide').forEach(slide => {
        slide.classList.remove('active');
    });
    document.querySelectorAll('.content-slide').forEach(content => {
        content.classList.remove('active');
    });

    // Adiciona active no slide correspondente
    const slideElement = document.querySelector(`[data-slide="${slideId}"]`);
    const contentElement = document.querySelector(`[data-content="${slideId}"]`);
    
    if (slideElement && contentElement) {
        slideElement.classList.add('active');
        contentElement.classList.add('active');
    }

    currentSlide = slideId;
}

// Navegação anterior
function prevSlide() {
    if (currentSlide === 'inicial') {
        showSlide(9); // Vai para o último
    } else if (currentSlide === 0) {
        showSlide('inicial'); // Volta para o inicial
    } else {
        showSlide(currentSlide - 1);
    }
}

// Navegação próxima
function nextSlide() {
    if (currentSlide === 'inicial') {
        showSlide(0); // Vai para o primeiro
    } else if (currentSlide === 9) {
        showSlide('inicial'); // Volta para o inicial
    } else {
        showSlide(currentSlide + 1);
    }
}

// Função chamada ao clicar no card
function goToActivity(activityIndex) {
    // Vai para o topo suavemente
    document.getElementById('heroSection').scrollIntoView({ 
        behavior: 'smooth',
        block: 'start'
    });
    
    // Aguarda scroll terminar e mostra o slide
    setTimeout(() => {
        showSlide(activityIndex);
    }, 500);
}

// Mobile menu toggle
function toggleMobileMenu() {
    const navMenu = document.getElementById('navMenu');
    navMenu.classList.toggle('active');
}