// Custom Carousel Implementation
let currentSlide = 0;
const slides = document.querySelectorAll('.carousel-slide');
const indicators = document.querySelectorAll('.indicator');
const totalSlides = slides.length;

const heroTexts = [
    {
        title: "Quem somos?",
        subtitle: "Somos a Baobab Zambeze Farm cultivamos na terra,<br> com a gente da terra, para o povo da terra. <br>De Kaunge em Tete, para Moçambique."
    },
    {
        title: "Onde estamos?",
        subtitle: "Estamos a cerca de 10 km do centro da cidade de Tete, <br>ao longo da EN9, a caminho da Zâmbia no povoado <br>de Kaunge ocupando uma área de cerca de 6 hectares para os Moçambicanos."
    },
    {
        title: "O que fazemos?",
        subtitle: "Lavramos a terra, lançamos as sementes, <br>irrigamos os campos e cultivamos o tomate, a cebola, <br> as couves, o repolho, as pimentas, o alface e mais."
    }
];

function updateSlide() {
    // Update slides
    slides.forEach((slide, index) => {
        slide.classList.toggle('active', index === currentSlide);
    });

    // Update indicators
    indicators.forEach((indicator, index) => {
        indicator.classList.toggle('active', index === currentSlide);
    });

    // Update text content
    const heroTitle = document.getElementById('heroTitle');
    const heroSubtitle = document.getElementById('heroSubtitle');

    // Add fade effect
    heroTitle.style.opacity = '0';
    heroSubtitle.style.opacity = '0';

    setTimeout(() => {
        heroTitle.textContent = heroTexts[currentSlide].title;
        heroSubtitle.innerHTML = heroTexts[currentSlide].subtitle;
        heroTitle.style.opacity = '1';
        heroSubtitle.style.opacity = '1';
    }, 300);
}

function nextSlide() {
    currentSlide = (currentSlide + 1) % totalSlides;
    updateSlide();
}

function prevSlide() {
    currentSlide = (currentSlide - 1 + totalSlides) % totalSlides;
    updateSlide();
}

function goToSlide(index) {
    currentSlide = index;
    updateSlide();
}

// Auto-advance carousel
let autoSlideInterval = setInterval(nextSlide, 5000);

// Pause auto-advance on hover
const carousel = document.getElementById('heroCarousel');
carousel.addEventListener('mouseenter', () => {
    clearInterval(autoSlideInterval);
});

carousel.addEventListener('mouseleave', () => {
    autoSlideInterval = setInterval(nextSlide, 5000);
});

// Mobile menu toggle
function toggleMobileMenu() {
    const navMenu = document.getElementById('navMenu');
    navMenu.classList.toggle('active');
}

const observerOptions = {
    threshold: 0.1,
    rootMargin: '0px 0px -50px 0px'
};

const observer = new IntersectionObserver((entries) => {
    entries.forEach(entry => {
        if (entry.isIntersecting) {
            entry.target.style.animationDelay = '0.2s';
            entry.target.style.animationFillMode = 'forwards';
        }
    });
}, observerOptions);

document.querySelectorAll('.fade-in').forEach(el => {
    observer.observe(el);
});

// Keyboard navigation for carousel
document.addEventListener('keydown', (e) => {
    if (e.key === 'ArrowLeft') {
        prevSlide();
    } else if (e.key === 'ArrowRight') {
        nextSlide();
    }
});

