<!-- Modern Footer -->
<footer class="modern-footer">
    <div class="container">
        <div class="footer-grid">
            <!-- Políticas Section -->
            <div class="footer-section">
                <h3><?= isset($footer['policies_title']) ? htmlspecialchars($footer['policies_title']) : 'Políticas' ?></h3>
                <?php if (isset($policy_links) && !empty($policy_links)): ?>
                    <?php foreach ($policy_links as $link): ?>
                        <a href="<?= htmlspecialchars($link['url']) ?>" class="footer-link">
                            <?= htmlspecialchars($link['label']) ?>
                        </a>
                    <?php endforeach; ?>
                <?php else: ?>
                    <a href="<?= url('/privacy') ?>" class="footer-link">Políticas de Privacidade</a>
                    <a href="<?= url('/terms') ?>" class="footer-link">Termos e Condições</a>
                <?php endif; ?>
            </div>

            <!-- Redes Sociais Section -->
            <div class="footer-section">
                <h3><?= isset($footer['social_title']) ? htmlspecialchars($footer['social_title']) : 'Redes Sociais' ?></h3>
                <div class="social-links">
                    <?php if (isset($social_links) && !empty($social_links)): ?>
                        <?php foreach ($social_links as $social): ?>
                            <a href="<?= htmlspecialchars($social['url']) ?>" 
                               class="social-link" 
                               target="_blank"
                               rel="noopener noreferrer">
                                <i class="<?= htmlspecialchars($social['icon_class']) ?>"></i>
                            </a>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <a href="#" class="social-link">
                            <i class="fab fa-facebook-f"></i>
                        </a>
                        <a href="#" class="social-link">
                            <i class="fab fa-instagram"></i>
                        </a>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Contactos Section -->
            <div class="footer-section">
                <h3><?= isset($footer['contacts_title']) ? htmlspecialchars($footer['contacts_title']) : 'Contactos' ?></h3>
                <div class="footer-text">
                    <?php if (isset($footer)): ?>
                        <?php if (!empty($footer['company_name'])): ?>
                            <p><strong><?= htmlspecialchars($footer['company_name']) ?></strong></p>
                        <?php endif; ?>
                        
                        <?php if (!empty($footer['address_line1'])): ?>
                            <p><?= htmlspecialchars($footer['address_line1']) ?></p>
                        <?php endif; ?>
                        
                        <?php if (!empty($footer['address_line2'])): ?>
                            <p><?= htmlspecialchars($footer['address_line2']) ?></p>
                        <?php endif; ?>
                        
                        <?php if (!empty($footer['address_line3'])): ?>
                            <p><?= htmlspecialchars($footer['address_line3']) ?></p>
                        <?php endif; ?>
                        
                        <?php if (!empty($footer['address_line4'])): ?>
                            <p><?= htmlspecialchars($footer['address_line4']) ?></p>
                        <?php endif; ?>
                        
                        <?php if (!empty($footer['phone1']) || !empty($footer['phone2'])): ?>
                            <p>
                                <?php if (!empty($footer['phone1'])): ?>
                                    Tel: <?= htmlspecialchars($footer['phone1']) ?>
                                <?php endif; ?>
                                <?php if (!empty($footer['phone1']) && !empty($footer['phone2'])): ?>
                                    / 
                                <?php endif; ?>
                                <?php if (!empty($footer['phone2'])): ?>
                                    <?= htmlspecialchars($footer['phone2']) ?>
                                <?php endif; ?>
                            </p>
                        <?php endif; ?>
                        
                        <?php if (!empty($footer['email_primary'])): ?>
                            <p>Email: <?= htmlspecialchars($footer['email_primary']) ?></p>
                        <?php endif; ?>
                    <?php else: ?>
                        <!-- Footer padrão caso não haja dados -->
                        <p><strong>Baobab Zambeze Farm</strong></p>
                        <p>Povoado de Kaunge, Distrito de Moatize</p>
                        <p>Província de Tete, Moçambique</p>
                        <p>EN9 - A caminho da Zâmbia</p>
                        <p>Tel: 862812986 / 846632923</p>
                        <p>Email: info@baobabzambeze.farm</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Copyright Section -->
        <div class="copyright">
            <div class="container">
                <p>
                    <?php 
                    if (isset($footer['copyright_text']) && !empty($footer['copyright_text'])) {
                        echo htmlspecialchars($footer['copyright_text']);
                    } else {
                        echo '© ' . date('Y') . ' Baobab Zambeze Farm. Todos os direitos reservados. Desenvolvido por Labore';
                    }
                    ?>
                </p>
            </div>
        </div>
    </div>
</footer>

<!-- JavaScript -->
<script>
    function toggleMobileMenu() {
        const navMenu = document.getElementById('navMenu');
        navMenu.classList.toggle('active');
    }
</script>

<!-- Page Specific JavaScript -->
<?php if (isset($page_js)): ?>
<script src="<?= asset('js/' . $page_js) ?>"></script>
<?php endif; ?>

</body>
</html>