<?php
/**
 * MODEL: PageProduction
 * Gerencia a página de Produção
 */
class PageProduction {
    private $db;
    
    public function __construct() {
        $this->db = Database::getInstance();
    }
    
    public function getByPageIdentifier($pageIdentifier) {
        $sql = "SELECT * FROM page_production WHERE page_identifier = ? AND is_active = 1 LIMIT 1";
        $stmt = $this->db->query($sql, [$pageIdentifier]);
        return $stmt ? $stmt->fetch() : null;
    }
    
    public function getCarouselImages($productionId) {
        $sql = "SELECT * FROM production_carousel 
                WHERE production_id = ? AND is_active = 1 
                ORDER BY display_order";
        $stmt = $this->db->query($sql, [$productionId]);
        return $stmt ? $stmt->fetchAll() : [];
    }
    
    public function getProducts($productionId) {
        $sql = "SELECT * FROM production_products 
                WHERE production_id = ? AND is_active = 1 
                ORDER BY card_number, display_order";
        $stmt = $this->db->query($sql, [$productionId]);
        return $stmt ? $stmt->fetchAll() : [];
    }
    
    public function getProductsByCard($productionId, $cardNumber) {
        $sql = "SELECT * FROM production_products 
                WHERE production_id = ? AND card_number = ? AND is_active = 1 
                ORDER BY display_order";
        $stmt = $this->db->query($sql, [$productionId, $cardNumber]);
        return $stmt ? $stmt->fetchAll() : [];
    }
    
    public function getStatistics($productionId) {
        $sql = "SELECT * FROM production_statistics 
                WHERE production_id = ? AND is_active = 1 
                ORDER BY display_order";
        $stmt = $this->db->query($sql, [$productionId]);
        return $stmt ? $stmt->fetchAll() : [];
    }
    
    public function update($id, $data) {
        $sql = "UPDATE page_production SET 
            statistics_title = ?, statistics_subtitle = ?
            WHERE id = ?";
        
        return $this->db->query($sql, [
            $data['statistics_title'],
            $data['statistics_subtitle'],
            $id
        ]);
    }
}