<?php 

/**
 * MODEL: PageHome
 * Gerencia a página principal (Sobre Nós)
 */
class PageHome {
    private $db;
    
    public function __construct() {
        $this->db = Database::getInstance();
    }
    
    public function getByPageIdentifier($pageIdentifier) {
        $sql = "SELECT * FROM page_home WHERE page_identifier = ? AND is_active = 1 LIMIT 1";
        $stmt = $this->db->query($sql, [$pageIdentifier]);
        return $stmt ? $stmt->fetch() : null;
    }
    
    public function getCarouselImages($pageHomeId) {
        $sql = "SELECT * FROM page_home_carousel 
                WHERE page_home_id = ? AND is_active = 1 
                ORDER BY display_order";
        $stmt = $this->db->query($sql, [$pageHomeId]);
        return $stmt ? $stmt->fetchAll() : [];
    }
    
    public function update($id, $data) {
        $sql = "UPDATE page_home SET 
            hero_title = ?, hero_subtitle = ?,
            mission_title = ?, mission_content = ?,
            vision_title = ?, vision_content = ?,
            values_title = ?, values_content = ?,
            history_title = ?, history_content = ?
            WHERE id = ?";
        
        return $this->db->query($sql, [
            $data['hero_title'],
            $data['hero_subtitle'],
            $data['mission_title'],
            $data['mission_content'],
            $data['vision_title'],
            $data['vision_content'],
            $data['values_title'],
            $data['values_content'],
            $data['history_title'],
            $data['history_content'],
            $id
        ]);
    }
}