<?php

/**
 * MODEL: LayoutHeader
 * Gerencia o cabeçalho e menu de navegação
 */
class LayoutHeader {
    private $db;
    
    public function __construct() {
        $this->db = Database::getInstance();
    }
    
    public function getHeader() {
        $sql = "SELECT * FROM layout_header LIMIT 1";
        $stmt = $this->db->query($sql);
        return $stmt ? $stmt->fetch() : null;
    }
    
    public function getMenuItems($headerId = null) {
        if ($headerId === null) {
            $header = $this->getHeader();
            $headerId = $header['id'] ?? 1;
        }
        
        $sql = "SELECT * FROM header_menu_items 
                WHERE header_id = ? AND is_active = 1 
                ORDER BY display_order";
        $stmt = $this->db->query($sql, [$headerId]);
        return $stmt ? $stmt->fetchAll() : [];
    }
}