<?php

/**
 * CONTROLLER: ContactController
 * Gerencia a página "Contacto"
 */
class ContactController {
    private $layoutHeadModel;
    private $layoutHeaderModel;
    private $pageContactModel;
    private $pageFooterModel;
    
    public function __construct() {
        $this->layoutHeadModel = new LayoutHead();
        $this->layoutHeaderModel = new LayoutHeader();
        $this->pageContactModel = new PageContact();
        $this->pageFooterModel = new PageFooter();
    }
    
    public function index() {
        // Buscar dados do HEAD
        $headData = $this->layoutHeadModel->getByPageIdentifier('contact');
        
        // Buscar dados do HEADER
        $headerData = $this->layoutHeaderModel->getHeader();
        $menuItems = $this->layoutHeaderModel->getMenuItems();
        
        // Buscar dados da página de CONTACTO
        $pageData = $this->pageContactModel->getByPageIdentifier('contact');
        
        // Buscar fotos da galeria (sempre busca, não depende do pageData)
        $galleryPhotos = $this->pageContactModel->getGalleryPhotos();

        // Buscar dados do FOOTER
        $footerData = $this->pageFooterModel->getFooter();
        $policyLinks = $this->pageFooterModel->getPolicyLinks();
        $socialLinks = $this->pageFooterModel->getSocialLinks();
        
        $data = [
            'head' => $headData,
            'header' => $headerData,
            'menu_items' => $menuItems,
            'page' => $pageData,
            'footer' => $footerData,
            'policy_links' => $policyLinks,
            'social_links' => $socialLinks,
            'current_page' => 'contact',
            'gallery_photos' => $galleryPhotos
        ];
        
        view('contact/index', $data);
    }
    
    public function submit() {
        if (!is_post()) {
            redirect('/contact');
        }
        
        // Validar dados
        $firstName = post('first_name');
        $lastName = post('last_name');
        $email = post('email');
        $message = post('message');
        
        $errors = [];
        
        if (!validate_required($firstName)) {
            $errors[] = 'Nome é obrigatório';
        }
        
        if (!validate_required($lastName)) {
            $errors[] = 'Apelido é obrigatório';
        }
        
        if (!validate_required($email) || !validate_email($email)) {
            $errors[] = 'Email válido é obrigatório';
        }
        
        if (!validate_required($message)) {
            $errors[] = 'Mensagem é obrigatória';
        }
        
        if (!empty($errors)) {
            redirect('/contact?error=validation');
        }
        
        // Salvar mensagem
        $data = [
            'first_name' => $firstName,
            'last_name' => $lastName,
            'email' => $email,
            'message' => $message
        ];
        
        if ($this->pageContactModel->saveMessage($data)) {
            redirect('/contact?success=1');
        } else {
            redirect('/contact?error=database');
        }
        
        redirect('/contact');
    }
}