<?php

class ActivitiesController {
    private $layoutHeadModel;
    private $layoutHeaderModel;
    private $pageActivitiesModel;
    private $pageFooterModel;
    
    public function __construct() {
        $this->layoutHeadModel = new LayoutHead();
        $this->layoutHeaderModel = new LayoutHeader();
        $this->pageActivitiesModel = new PageActivities();
        $this->pageFooterModel = new PageFooter();
    }
    
    
    public function index() {
        // Buscar dados do HEAD
        $headData = $this->layoutHeadModel->getByPageIdentifier('activities');
        
        // Buscar dados do HEADER
        $headerData = $this->layoutHeaderModel->getHeader();
        $menuItems = $this->layoutHeaderModel->getMenuItems();
        
        // Buscar dados da página ACTIVITIES
        $pageData = $this->pageActivitiesModel->getByPageIdentifier('activities');
        $slides = [];
        $socialCards = [];
        $agriculturalCards = [];
        if ($pageData) {
            // Buscar todos os slides
            $slides = $this->pageActivitiesModel->getSlides($pageData['id']);
            
            // Buscar cards por categoria
            $socialCards = $this->pageActivitiesModel->getCards($pageData['id'], 'social');
            $agriculturalCards = $this->pageActivitiesModel->getCards($pageData['id'], 'agricultural');
        }
        
        // Buscar dados do FOOTER
        $footerData = $this->pageFooterModel->getFooter();
        $policyLinks = $this->pageFooterModel->getPolicyLinks();
        $socialLinks = $this->pageFooterModel->getSocialLinks();
        
        // Passar dados para a view
        $data = [
            'head' => $headData,
            'header' => $headerData,
            'menu_items' => $menuItems,
            'page' => $pageData,
            'slides' => $slides,
            'social_cards' => $socialCards,
            'agricultural_cards' => $agriculturalCards,
            'footer' => $footerData,
            'policy_links' => $policyLinks,
            'social_links' => $socialLinks,
            'current_page' => 'activities'
        ];
        
        view('activities/index', $data);
    }
}